<?php
/* ==== File Desk (PHP 5.2+) ==== */
/* DEBUG dev:
ini_set('display_errors', 1); error_reporting(E_ALL);
*/

if(function_exists('mb_internal_encoding')){@mb_internal_encoding('UTF-8');}
session_start();

require dirname(__FILE__).'/config.php';
require dirname(__FILE__).'/functions/common.php';
require dirname(__FILE__).'/functions/auth.php';
require dirname(__FILE__).'/functions/fs.php';

/* ========== BASE ROOT YANG DIIZINKAN ========== */
$base = BASE_DIR !== '' ? safe_realpath(BASE_DIR) : getcwd();
if(!$base){ $base = getcwd(); }
if(!defined('BASE_PATH')) define('BASE_PATH',$base);

/* flash session init */
if(!isset($_SESSION['_flash'])) $_SESSION['_flash']=array('ok'=>array(),'err'=>array());

/* logout */
if(isset($_GET['a']) && $_GET['a']==='logout'){
  do_logout();
  header('Location: index.php');
  exit;
}

/* login gate */
if(!logged_in()){
  if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['login'])){
    $u = isset($_POST['user'])?(string)$_POST['user']:'';
    $p = isset($_POST['pass'])?(string)$_POST['pass']:'';
    if(do_login($u,$p)){
      header('Location: index.php');
      exit;
    } else {
      $err='Username atau password salah.';
    }
  }
  include dirname(__FILE__).'/inc/header.php';
  include dirname(__FILE__).'/inc/login.php';
  include dirname(__FILE__).'/inc/footer.php';
  exit;
}

/* ===== helper amanin path agar tetap di bawah BASE_PATH ===== */
function resolve_path($raw){
    // kalau kosong => BASE_PATH
    if(!$raw){ $raw = BASE_PATH; }

    // kalau bukan absolute (di Linux) atau bukan drive path (Windows), gabung ke BASE_PATH
    if(substr($raw,0,1)!=='/' && substr($raw,1,1)!==':'){
        $raw = BASE_PATH . DIRECTORY_SEPARATOR . $raw;
    }

    // coba realpath
    $real = safe_realpath($raw);

    // kalau gagal realpath (misal file/folder baru yg belum ada), fallback raw lagi
    if(!$real){
        $real = $raw;
    }

    // pastikan masih di dalam BASE_PATH
    $inside = ensure_in_base($real);
    if(!$inside){
        $inside = BASE_PATH;
    }

    // kalau bukan dir yang valid untuk navigasi folder, tapi kita butuh path target (mis. upload ke folder yang memang ada),
    // kita kembalikan apa adanya. Untuk listing nanti kita cek lagi.
    return $inside;
}

/* POST actions */
if($_SERVER['REQUEST_METHOD']==='POST'){
  // kamu minta jangan CSRF
  // csrf_check(); <-- dimatikan

  // ambil path aktif dari POST
  $postedP = isset($_POST['p'])?(string)$_POST['p']:BASE_PATH;
  $path = resolve_path($postedP);

  try {
    $action = isset($_POST['a'])?(string)$_POST['a']:'';

    /* ====== SAVE (edit file text) ====== */
    if($action==='save'){
      $file = isset($_POST['file'])?(string)$_POST['file']:'';
      $target = ensure_in_base(safe_realpath($file));
      if(!$target || !is_file($target)) throw new Exception('File tidak valid.');
      if(!is_writable($target)) throw new Exception('Tidak punya izin menulis file ini.');
      $data = isset($_POST['content'])?(string)$_POST['content']:'';
      if(strlen($data) > MAX_EDIT_BYTES) throw new Exception('Ukuran konten melebihi batas edit.');
      if(@file_put_contents($target,$data)===false) throw new Exception('Gagal menyimpan file.');
      flash_ok('Berhasil menyimpan perubahan.');

    /* ====== RENAME ====== */
    } elseif($action==='rename'){
      $old = ensure_in_base(safe_realpath(isset($_POST['old'])?$_POST['old']:''));
      $new = ensure_in_base(safe_realpath(isset($_POST['new'])?$_POST['new']:''));
      if(!$old || !file_exists($old)) throw new Exception('Path asal tidak ditemukan.');
      if(!$new) throw new Exception('Target baru tidak valid.');
      if(file_exists($new)) throw new Exception('Target baru sudah ada.');
      if(!@rename($old,$new)) throw new Exception('Gagal rename.');
      flash_ok('Berhasil mengganti nama.');

    /* ====== DELETE ====== */
    } elseif($action==='delete'){
      $target = ensure_in_base(safe_realpath(isset($_POST['target'])?$_POST['target']:''));
      if(!$target || !file_exists($target)) throw new Exception('Target tidak ditemukan.');
      if(!is_writable($target) && !is_writable(dirname($target))) throw new Exception('Tidak punya izin menghapus.');
      if(!rrmdir($target)) throw new Exception('Gagal menghapus (cek izin).');
      flash_ok('Berhasil menghapus.');

    /* ====== ZIP ====== */
    } elseif($action==='zip'){
      ensure_zip_enabled();
      $items = isset($_POST['items'])?$_POST['items']:array();
      if(!is_array($items) || count($items)===0) throw new Exception('Tidak ada item dipilih.');

      $zipName = isset($_POST['zipname'])?trim((string)$_POST['zipname']):'arsip.zip';
      if($zipName==='') $zipName='arsip.zip';
      if(!str_ends_with(strtolower($zipName),'.zip')) $zipName.='.zip';

      // buat zip di folder aktif
      $zipPathRaw = $path.DIRECTORY_SEPARATOR.$zipName;
      $zipPath = ensure_in_base(safe_realpath($zipPathRaw));
      if(!$zipPath){
        // kalau file zip belum ada jadi realpath false, pakai raw
        $zipPath = $zipPathRaw;
      }

      if(file_exists($zipPath)) throw new Exception('Nama ZIP sudah ada.');
      $zip = new ZipArchive();
      if($zip->open($zipPath, ZipArchive::CREATE)!==true) throw new Exception('Gagal membuat file ZIP.');

      foreach($items as $i){
        $ip = ensure_in_base(safe_realpath($i));
        if(!$ip || !file_exists($ip)) continue;
        add_to_zip($zip,$ip,basename($ip));
      }

      $zip->close();
      flash_ok('Berhasil membuat ZIP: '.$zipName);

    /* ====== UNZIP ====== */
    } elseif($action==='unzip'){
      ensure_zip_enabled();
      $zipFile = ensure_in_base(safe_realpath(isset($_POST['zipfile'])?$_POST['zipfile']:''));
      if(!$zipFile || !is_file($zipFile)) throw new Exception('File ZIP tidak valid.');

      $destRaw = isset($_POST['dest'])?$_POST['dest']:$path;
      $dest = resolve_path($destRaw);

      if(!$dest || !is_dir($dest)) throw new Exception('Folder tujuan tidak valid.');
      if(!is_writable($dest)) throw new Exception('Tidak punya izin tulis di folder tujuan.');

      $zip = new ZipArchive();
      if($zip->open($zipFile)!==true) throw new Exception('Gagal membuka ZIP.');
      if(!$zip->extractTo($dest)) { $zip->close(); throw new Exception('Gagal ekstrak ZIP.'); }
      $zip->close();

      flash_ok('Berhasil mengekstrak: '.basename($zipFile).' → '.$dest);

    /* ====== UPLOAD (PAKAI file_put_contents) ====== */
    } elseif($action==='upload'){
      if(!is_dir($path)) throw new Exception('Folder tujuan tidak valid.');
      if(!is_writable($path)) throw new Exception('Tidak punya izin tulis di folder ini.');
      if(empty($_FILES['files'])) throw new Exception('Tidak ada file diunggah.');

      $overwrite = !empty($_POST['overwrite']);
      $okCount = 0;
      $fail = array();

      $names  = isset($_FILES['files']['name'])     ? $_FILES['files']['name']     : array();
      $errors = isset($_FILES['files']['error'])    ? $_FILES['files']['error']    : array();
      $tmps   = isset($_FILES['files']['tmp_name']) ? $_FILES['files']['tmp_name'] : array();

      $count = is_array($names)?count($names):0;

      for($i=0;$i<$count;$i++){
        $origName = (string)$names[$i];
        $errNo    = isset($errors[$i]) ? $errors[$i] : UPLOAD_ERR_NO_FILE;

        if($errNo!==UPLOAD_ERR_OK){
          $fail[] = $origName.' (error='.$errNo.')';
          continue;
        }

        $tmp  = isset($tmps[$i]) ? $tmps[$i] : '';
        $base = basename($origName);

        // pastikan tmp file ada
        if($base==='' || !file_exists($tmp)){
          $fail[] = $origName.' (invalid tmp)';
          continue;
        }

        // path tujuan final di folder aktif
        $dest = $path.DIRECTORY_SEPARATOR.$base;

        // auto rename kalau nama sudah ada dan overwrite=off
        if(file_exists($dest) && !$overwrite){
          $nameNoExt = pathinfo($base,PATHINFO_FILENAME);
          $ext       = pathinfo($base,PATHINFO_EXTENSION);
          $n=1;
          while(true){
            $cand = $nameNoExt.' ('.$n.')'.($ext!==''?'.'.$ext:'');
            $try  = $path.DIRECTORY_SEPARATOR.$cand;
            if(!file_exists($try) || $n>=10000){
              $dest = $try;
              break;
            }
            $n++;
          }
        }

        // --- INI BAGIAN BARU ---
        // baca isi tmp file
        $data = @file_get_contents($tmp);
        if($data === false){
          $fail[] = $origName.' (gagal membaca file sementara)';
          continue;
        }

        // tulis isi tmp ke tujuan akhir
        if(@file_put_contents($dest, $data) === false){
          $fail[] = $origName.' (gagal menyimpan dengan file_put_contents ke '.$dest.')';
          continue;
        }

        $okCount++;
      }

      if($okCount>0) flash_ok("Upload berhasil: {$okCount} file.");
      if(!empty($fail)) flash_err("Gagal: ".implode(', ', $fail));

    /* ====== MKDIR ====== */
    } elseif($action==='mkdir'){
      if(!is_dir($path)) throw new Exception('Folder induk tidak valid.');
      if(!is_writable($path)) throw new Exception('Tidak punya izin tulis di folder ini.');
      $name = isset($_POST['folder'])?trim((string)$_POST['folder']):'';
      if($name==='') throw new Exception('Nama folder tidak boleh kosong.');
      if(preg_match('~[\/\\\\]~',$name) || strpos($name,'..')!==false) throw new Exception('Nama folder tidak boleh mengandung /, \\ atau \"..\".');
      if(!preg_match('~^[\w\s\-\._\(\)\[\]\{\},@+#=]+$~u',$name)) throw new Exception('Nama folder mengandung karakter tidak valid.');
      $dest = $path.DIRECTORY_SEPARATOR.$name;
      if(file_exists($dest)) throw new Exception('Folder sudah ada.');
      $old = umask(0); $ok=@mkdir($dest,0775,true); umask($old);
      if(!$ok) throw new Exception('Gagal membuat folder (cek izin).');
      flash_ok('Berhasil membuat folder: '.$name);
    }

  } catch(Exception $e){
    flash_err($e->getMessage());
  }

  // setelah POST, redirect balik biar gak resubmit form kalo refresh
  header('Location: ?p='.rawurlencode($path));
  exit;
}

/* ====== DOWNLOAD (GET) ====== */
if(isset($_GET['a']) && $_GET['a']==='download'){
  $file = isset($_GET['file'])?(string)$_GET['file']:'';
  $fp=ensure_in_base(safe_realpath($file));
  if(!$fp || !is_file($fp) || !is_readable($fp)){
    http_response_code(404);
    exit('File tidak ditemukan / tidak bisa dibaca.');
  }
  while(ob_get_level()){ ob_end_clean(); }
  header('Content-Type: application/octet-stream');
  header('Content-Length: '.filesize($fp));
  header('Content-Disposition: attachment; filename="'.basename($fp).'"');
  header('X-Content-Type-Options: nosniff');
  readfile($fp);
  exit;
}

/* ====== RENDER (GET biasa) ====== */

$p = isset($_GET['p'])?(string)$_GET['p']:BASE_PATH;
$abs = resolve_path($p);

/* header */
include dirname(__FILE__).'/inc/header.php';

/* mode edit */
if(isset($_GET['a']) && $_GET['a']==='edit'){
  $file = isset($_GET['file'])?(string)$_GET['file']:'';
  $fp=ensure_in_base(safe_realpath($file));
  if($fp && is_file($fp) && is_readable($fp) && filesize($fp)<=MAX_EDIT_BYTES && is_text_file($fp)){
    $content=@file_get_contents($fp); if($content===false)$content='';
    include dirname(__FILE__).'/inc/edit.php';
  } else {
    echo '<div class="alert err">File tidak bisa diedit.</div><p><a class="btn" href="?p='.h($abs).'">Kembali</a></p>';
  }
} else {
  $canRead=is_readable($abs);
  $canList=$canRead&&is_dir($abs);
  $listing=$canList?list_dir($abs):array('dirs'=>array(),'files'=>array());
  include dirname(__FILE__).'/inc/list.php';
}

/* footer */
include dirname(__FILE__).'/inc/footer.php';
